//import getAllCookies from './modules/get_all_cookies.mjs';

/**
 * Update icon badge counter on active page
 */
/**
const updateBadgeCounter = async () => {
  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
  if (!tab) {
    return;
  }
  const { id: tabId, url: urlString } = tab;
  if (!urlString) {
    chrome.action.setBadgeText({ tabId, text: '' });
    return;
  }
  const url = new URL(urlString);
  const cookies = await getAllCookies({ url: url.href, partitionKey: { topLevelSite: url.origin } });
  const text = cookies.length.toFixed();
  chrome.action.setBadgeText({ tabId, text });
};

chrome.cookies.onChanged.addListener(updateBadgeCounter);
chrome.tabs.onUpdated.addListener(updateBadgeCounter);
chrome.tabs.onActivated.addListener(updateBadgeCounter);
chrome.windows.onFocusChanged.addListener(updateBadgeCounter);
*/


// 洢ӵ
const VideoPlaybackPotRequests = [];
const poTokenRequests = [];

// 
chrome.webRequest.onBeforeRequest.addListener(
  function(details) {
    const urllowcase = details.url.toLowerCase();
    // URLǷͬʱؼ
    if (urllowcase.startsWith('http') && urllowcase.includes('videoplayback') && urllowcase.includes('pot')) {
      // ƴ洢ֹڴ
      if (VideoPlaybackPotRequests.length > 5) {
        VideoPlaybackPotRequests.shift(); // Ƴɵļ¼
      }
      VideoPlaybackPotRequests.push({
        url: details.url,
        method: details.method,
        type: details.type,
        time: new Date().toLocaleTimeString()
      });
      
      
      // ӡ̨
      //console.log(`${details.url}`);
    }else if (urllowcase.startsWith('http') && urllowcase.includes('youtube.com') && urllowcase.includes('v1/player')) {
      if (details.requestBody && details.requestBody.raw) {
        const rawData = details.requestBody.raw;
        rawData.forEach(data => {
          try {
            const decoder = new TextDecoder();
            const payloadString = decoder.decode(data.bytes);

            // JSON
            try {
              const jsonPayload = JSON.parse(payloadString);
              const poToken = jsonPayload.serviceIntegrityDimensions?.poToken;
              console.log('poToken:', poToken);
              //console.log('JSON payload:', jsonPayload);
              if(poToken.length > 10){
                 // ƴ洢ֹڴ
                if (poTokenRequests.length > 0) {
                  poTokenRequests.shift(); // Ƴɵļ¼
                }
                poTokenRequests.push({
                  data: poToken,
                  time: new Date().toLocaleTimeString()
                });
              }
            } catch (e) {
              //console.log('Text payload:', payloadString);
            }
          } catch (error) {
            //console.error('Error decoding payload:', error);
          }
        });
      }
      // ӡ̨
      //console.log(`[Request] ${details.method} ${details.url}`);
      //console.log(`[Data] ${details.requestBody.raw}`);
    }
  },
  {urls: ["<all_urls>"]}, // ƥURL
  ["requestBody"] // ҪrequestBodyȨ
);

// ṩȡƥķ
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.type === 'GET_MATCHED_REQUESTS') {
    sendResponse({requests: VideoPlaybackPotRequests});
  }
  if (request.type === "CLEAR_MATCHED_REQUESTS") {
    VideoPlaybackPotRequests = [];
    sendResponse({success: true});
  }
  if (request.type === 'GET_POTOKEN_REQUESTS') {
    sendResponse({requests: poTokenRequests});
  }
});
